/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class EnvyModifier
extends Modifier
implements TooltipModifierHook,
AttributesModifierHook,
InventoryTickModifierHook,
MeleeHitModifierHook,
ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
ConditionalStatModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "envy");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.ATTRIBUTES, ModifierHooks.INVENTORY_TICK, ModifierHooks.MELEE_HIT, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_LAUNCH});
    }

    private static MobEffectInstance makeSlownessEffect(int level) {
        return new MobEffectInstance((MobEffect)Utils.envied.get(), 40, Math.min(10, level));
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, ModifierEntry modifier, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(modifier.getLevel() * effectLevel) / scale;
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && !context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(10, ((TinkerEffect)Utils.envyEffect.get()).getLevel(attacker) + 1);
            ((TinkerEffect)Utils.envyEffect.get()).apply(attacker, 40, effectLevel, true);
            target.m_7292_(EnvyModifier.makeSlownessEffect(effectLevel));
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putFloat(this.KEY, persistentData.getFloat(this.KEY) + 1.0f);
        }
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(10, ((TinkerEffect)Utils.envyEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.envyEffect.get()).apply(shooter, 40, effectLevel, true);
            persistentData.putFloat(this.KEY, persistentData.getFloat(this.KEY) + 1.0f);
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && attacker != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_7292_(EnvyModifier.makeSlownessEffect(((TinkerEffect)Utils.envyEffect.get()).getLevel(attacker)));
        }
        return false;
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.f_19797_ % 8 == 0 && holder.m_21211_() != stack && isSelected) {
            ModDataNBT persistentData = tool.getPersistentData();
            if (((TinkerEffect)Utils.envyEffect.get()).getLevel(holder) == -1) {
                persistentData.remove(this.KEY);
            }
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        double boost;
        if (slot == EquipmentSlot.MAINHAND && tool.hasTag(TinkerTags.Items.MELEE) && (boost = (double)(Math.min(10.0f, tool.getPersistentData().getFloat(this.KEY)) * (float)modifier.getLevel() / 8.0f)) != 0.0) {
            consumer.accept(Attributes.f_22283_, new AttributeModifier(UUID.fromString("7883363c-6fc7-48c0-8ca4-14cad2cf6f66"), Attributes.f_22283_.m_22087_(), boost, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        return stat == ToolStats.DRAW_SPEED ? baseValue + EnvyModifier.getBonus(living, Utils.envyEffect, modifier, 16.0f) * tool.getMultiplier((INumericToolStat)ToolStats.DRAW_SPEED) : baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (tool.hasTag(TinkerTags.Items.RANGED) && tooltipKey == TooltipKey.SHIFT) {
            TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.VELOCITY, (TagKey)TinkerTags.Items.RANGED, (float)EnvyModifier.getBonus((LivingEntity)player, Utils.envyEffect, modifier, 16.0f), tooltip);
        }
    }
}

